/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import io.netty.buffer.ByteBufUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class PayloadTypeRegistryImpl<B extends FriendlyByteBuf>
implements PayloadTypeRegistry<B> {
    public static final PayloadTypeRegistryImpl<FriendlyByteBuf> CONFIGURATION_C2S = new PayloadTypeRegistryImpl(ConnectionProtocol.CONFIGURATION, PacketFlow.SERVERBOUND);
    public static final PayloadTypeRegistryImpl<FriendlyByteBuf> CONFIGURATION_S2C = new PayloadTypeRegistryImpl(ConnectionProtocol.CONFIGURATION, PacketFlow.CLIENTBOUND);
    public static final PayloadTypeRegistryImpl<RegistryFriendlyByteBuf> PLAY_C2S = new PayloadTypeRegistryImpl(ConnectionProtocol.PLAY, PacketFlow.SERVERBOUND);
    public static final PayloadTypeRegistryImpl<RegistryFriendlyByteBuf> PLAY_S2C = new PayloadTypeRegistryImpl(ConnectionProtocol.PLAY, PacketFlow.CLIENTBOUND);
    private final Map<Identifier, CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload>> packetTypes = new HashMap<Identifier, CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload>>();
    private final Object2IntMap<Identifier> maxPacketSize = new Object2IntOpenHashMap();
    private final ConnectionProtocol state;
    private final PacketFlow side;
    private final int minimalSplittableSize;

    private PayloadTypeRegistryImpl(ConnectionProtocol state, PacketFlow side) {
        this.state = state;
        this.side = side;
        this.minimalSplittableSize = side == PacketFlow.CLIENTBOUND ? 0x100000 : Short.MAX_VALUE;
    }

    public static @Nullable PayloadTypeRegistryImpl<?> get(ProtocolInfo<?> state) {
        return switch (state.id()) {
            case ConnectionProtocol.CONFIGURATION -> {
                if (state.flow() == PacketFlow.CLIENTBOUND) {
                    yield CONFIGURATION_S2C;
                }
                yield CONFIGURATION_C2S;
            }
            case ConnectionProtocol.PLAY -> {
                if (state.flow() == PacketFlow.CLIENTBOUND) {
                    yield PLAY_S2C;
                }
                yield PLAY_C2S;
            }
            default -> null;
        };
    }

    @Override
    public <T extends CustomPacketPayload> CustomPacketPayload.TypeAndCodec<? super B, T> register(CustomPacketPayload.Type<T> id, StreamCodec<? super B, T> codec) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(codec, "codec");
        CustomPacketPayload.TypeAndCodec payloadType = new CustomPacketPayload.TypeAndCodec(id, codec.cast());
        if (this.packetTypes.containsKey(id.id())) {
            throw new IllegalArgumentException("Packet type " + String.valueOf(id) + " is already registered!");
        }
        this.packetTypes.put(id.id(), payloadType);
        return payloadType;
    }

    @Override
    public <T extends CustomPacketPayload> CustomPacketPayload.TypeAndCodec<? super B, T> registerLarge(CustomPacketPayload.Type<T> id, StreamCodec<? super B, T> codec, int maxPayloadSize) {
        if (maxPayloadSize < 0) {
            throw new IllegalArgumentException("Provided maxPayloadSize needs to be positive!");
        }
        CustomPacketPayload.TypeAndCodec<? super B, T> type = this.register(id, codec);
        int identifierSize = ByteBufUtil.utf8MaxBytes((CharSequence)id.id().toString());
        int maxPacketSize = maxPayloadSize + VarInt.getByteSize((int)identifierSize) + identifierSize + 10;
        if (maxPacketSize < 0) {
            maxPacketSize = Integer.MAX_VALUE;
        }
        if (maxPacketSize > this.minimalSplittableSize) {
            this.maxPacketSize.put((Object)id.id(), maxPacketSize);
        }
        return type;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload> get(Identifier id) {
        return this.packetTypes.get(id);
    }

    public <T extends CustomPacketPayload> // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CustomPacketPayload.TypeAndCodec<B, T> get(CustomPacketPayload.Type<T> id) {
        return this.packetTypes.get(id.id());
    }

    public int getMaxPacketSize(Identifier id) {
        return this.maxPacketSize.getOrDefault((Object)id, -1);
    }

    public ConnectionProtocol getPhase() {
        return this.state;
    }

    public PacketFlow getSide() {
        return this.side;
    }
}

