/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.List;
import java.util.function.Predicate;

import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.object.builder.v1.entity.MinecartComparatorLogicRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2313;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

@Mixin(class_2313.class)
public abstract class DetectorRailBlockMixin {
	@Shadow protected abstract <T extends class_1688> List<T> getCarts(class_1937 world, class_2338 pos, Class<T> entityClass, @Nullable Predicate<class_1297> entityPredicate);

	@Inject(at = @At("HEAD"), method = "getComparatorOutput", cancellable = true)
	private void getCustomComparatorOutput(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction, CallbackInfoReturnable<Integer> cir) {
		if (state.method_11654(class_2313.field_10913)) {
			List<class_1688> carts = getCarts(world, pos, class_1688.class,
					cart -> MinecartComparatorLogicRegistry.getCustomComparatorLogic(cart.method_5864()) != null);
			for (class_1688 cart : carts) {
				int comparatorValue = MinecartComparatorLogicRegistry.getCustomComparatorLogic(cart.method_5864())
						.getComparatorValue(cart, state, pos);
				if (comparatorValue >= 0) {
					cir.setReturnValue(comparatorValue);
					break;
				}
			}
		}
	}
}
