/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.particle.v1;

import java.util.Locale;
import java.util.function.Function;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.impl.client.particle.ParticleRendererRegistryImpl;
import net.minecraft.class_11938;
import net.minecraft.class_2960;
import net.minecraft.class_3999;
import net.minecraft.class_702;

/**
 * A registry for custom {@link class_11938}s.
 */
public final class ParticleRendererRegistry {
	/**
	 * Registers a {@link class_11938} factory for the given {@link class_3999}.
	 *
	 * @param textureSheet the texture sheet
	 * @param function the factory function
	 */
	public static void register(class_3999 textureSheet, Function<class_702, class_11938<?>> function) {
		ParticleRendererRegistryImpl.INSTANCE.register(textureSheet, function);
	}

	/**
	 * Registers a rendering order between two {@link class_3999}s.
	 *
	 * <p>The first texture sheet will be rendered before the second texture sheet.
	 *
	 * <p>Note that the rendering order of vanilla texture sheets is already defined by Minecraft,
	 * and you cannot change the order of vanilla texture sheets with this method.
	 *
	 * @param first  the texture sheet to render first
	 * @param second the texture sheet to render second
	 */
	public static void registerOrdering(class_3999 first, class_2960 second) {
		registerOrdering(getId(first), second);
	}

	/**
	 * Registers a rendering order between two {@link class_3999}s.
	 *
	 * <p>The first texture sheet will be rendered before the second texture sheet.
	 *
	 * <p>Note that the rendering order of vanilla texture sheets is already defined by Minecraft,
	 * and you cannot change the order of vanilla texture sheets with this method.
	 *
	 * @param first  the texture sheet to render first
	 * @param second the texture sheet to render second
	 */
	public static void registerOrdering(class_3999 first, class_3999 second) {
		registerOrdering(getId(first), getId(second));
	}

	/**
	 * Registers a rendering order between two {@link class_3999}s.
	 *
	 * <p>The first texture sheet will be rendered before the second texture sheet.
	 *
	 * <p>Note that the rendering order of vanilla texture sheets is already defined by Minecraft,
	 * and you cannot change the order of vanilla texture sheets with this method.
	 *
	 * @param first  the texture sheet to render first
	 * @param second the texture sheet to render second
	 */
	public static void registerOrdering(class_2960 first, class_3999 second) {
		registerOrdering(first, getId(second));
	}

	/**
	 * Registers a rendering order between two {@link class_3999}s.
	 *
	 * <p>The first texture sheet will be rendered before the second texture sheet.
	 *
	 * <p>Note that the rendering order of vanilla texture sheets is already defined by Minecraft,
	 * and you cannot change the order of vanilla texture sheets with this method.
	 *
	 * @param first  the texture sheet to render first
	 * @param second the texture sheet to render second
	 */
	public static void registerOrdering(class_2960 first, class_2960 second) {
		ParticleRendererRegistryImpl.INSTANCE.registerOrdering(first, second);
	}

	/**
	 * Gets the {@link class_3999} registered with the given identifier.
	 *
	 * @param id the identifier of the texture sheet
	 * @return the texture sheet, or null if none is registered with the given identifier
	 */
	public static @Nullable class_3999 getParticleTextureSheet(class_2960 id) {
		return ParticleRendererRegistryImpl.INSTANCE.getParticleTextureSheet(id);
	}

	/**
	 * Gets the identifier for the given {@link class_3999}.
	 *
	 * @param textureSheet the texture sheet
	 * @return the identifier
	 */
	public static class_2960 getId(class_3999 textureSheet) {
		if (textureSheet == class_3999.field_62622
				|| textureSheet == class_3999.field_17832
				|| textureSheet == class_3999.field_62624
				|| textureSheet == class_3999.field_62623) {
			return class_2960.method_60656(textureSheet.comp_3340().toLowerCase(Locale.ROOT));
		}

		return class_2960.method_60654(textureSheet.comp_3340());
	}

	private ParticleRendererRegistry() {
	}
}
