/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.particle.v1;

import org.jspecify.annotations.Nullable;
import net.fabricmc.fabric.impl.particle.BlockStateParticleEffectFactoryImpl;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2396;
import net.minecraft.class_2680;

/**
 * Note: This interface is automatically implemented on {@link class_2388} via Mixin and interface injection.
 */
public interface FabricBlockStateParticleEffect {
	/**
	 * Alternative for {@link class_2388#class_2388(class_2396, class_2680)} that also
	 * accepts a {@link class_2338}. This method should be used instead of the vanilla constructor when the block state
	 * is retrieved using a block pos, most commonly through {@link class_1922#method_8320(class_2338)}. This ensures
	 * that any particles created from this effect use an accurate pos for any client-side logic.
	 *
	 * <p>If an instance with a non-null block pos needs to be synced to the client, the block pos will only be synced
	 * if it is known that the client supports decoding it (has this Fabric API module installed); otherwise, the effect
	 * will be sent as a vanilla effect and the client will produce a null block pos.
	 *
	 * @param type the particle type
	 * @param blockState the block state
	 * @param blockPos the block pos from which the block state was retrieved
	 * @return the particle effect
	 */
	static class_2388 create(class_2396<class_2388> type, class_2680 blockState, @Nullable class_2338 blockPos) {
		return BlockStateParticleEffectFactoryImpl.create(type, blockState, blockPos);
	}

	/**
	 * @return the block pos from which {@linkplain class_2388#method_10278() the block state} was
	 * retrieved, or {@code null} if not applicable or this instance was synced from a remote server that does not have
	 * this Fabric API module installed
	 */
	@Nullable
	default class_2338 getBlockPos() {
		throw new AssertionError("Implemented in Mixin");
	}
}
