/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientPayloadC2S;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientPayloadS2C;
import net.fabricmc.fabric.impl.recipe.ingredient.SupportedIngredientsClientConnection;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;

public class CustomIngredientSync
implements ModInitializer {
    public static final class_2960 PACKET_ID = class_2960.method_60655((String)"fabric", (String)"custom_ingredient_sync");
    public static final int PROTOCOL_VERSION_1 = 1;
    public static final ThreadLocal<Set<class_2960>> CURRENT_SUPPORTED_INGREDIENTS = new ThreadLocal();

    public static CustomIngredientPayloadC2S createResponsePayload(int serverProtocolVersion) {
        if (serverProtocolVersion < 1) {
            return null;
        }
        return new CustomIngredientPayloadC2S(1, CustomIngredientImpl.REGISTERED_SERIALIZERS.keySet());
    }

    public static Set<class_2960> decodeResponsePayload(CustomIngredientPayloadC2S payload) {
        int protocolVersion = payload.protocolVersion();
        switch (protocolVersion) {
            case 1: {
                Set<class_2960> serializers = payload.registeredSerializers();
                serializers.removeIf(id -> !CustomIngredientImpl.REGISTERED_SERIALIZERS.containsKey(id));
                return serializers;
            }
        }
        throw new IllegalArgumentException("Unknown ingredient sync protocol version: " + protocolVersion);
    }

    public void onInitialize() {
        PayloadTypeRegistry.configurationC2S().register(CustomIngredientPayloadC2S.ID, CustomIngredientPayloadC2S.CODEC);
        PayloadTypeRegistry.configurationS2C().register(CustomIngredientPayloadS2C.ID, CustomIngredientPayloadS2C.CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)PACKET_ID)) {
                handler.addTask((class_8605)new IngredientSyncTask());
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(CustomIngredientPayloadC2S.ID, (payload, context) -> {
            Set<class_2960> supportedCustomIngredients = CustomIngredientSync.decodeResponsePayload(payload);
            ((SupportedIngredientsClientConnection)((ServerCommonNetworkHandlerAccessor)context.networkHandler()).getConnection()).fabric_setSupportedCustomIngredients(supportedCustomIngredients);
            context.networkHandler().completeTask(IngredientSyncTask.KEY);
        });
    }

    private record IngredientSyncTask() implements class_8605
    {
        public static final class_8605.class_8606 KEY = new class_8605.class_8606(PACKET_ID.toString());

        public void method_52376(Consumer<class_2596<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)new CustomIngredientPayloadS2C(1)));
        }

        public class_8605.class_8606 method_52375() {
            return KEY;
        }
    }
}

