/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import java.util.Set;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientSync;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jspecify.annotations.Nullable;

public class CustomIngredientPacketCodec
implements class_9139<class_9129, class_1856> {
    static final int PACKET_MARKER = -1;
    private final class_9139<class_9129, class_1856> fallback;

    public CustomIngredientPacketCodec(class_9139<class_9129, class_1856> fallback) {
        this.fallback = fallback;
    }

    public class_1856 decode(class_9129 buf) {
        int index = buf.readerIndex();
        if (buf.method_10816() != -1) {
            buf.method_52988(index);
            return (class_1856)this.fallback.decode((Object)buf);
        }
        class_2960 type = buf.method_10810();
        CustomIngredientSerializer<?> serializer = CustomIngredientSerializer.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Cannot deserialize custom ingredient of unknown type " + String.valueOf(type));
        }
        return ((CustomIngredient)serializer.getPacketCodec().decode((Object)buf)).toVanilla();
    }

    public void encode(class_9129 buf, class_1856 value) {
        CustomIngredient customIngredient = value.getCustomIngredient();
        if (CustomIngredientPacketCodec.shouldEncodeFallback(customIngredient)) {
            this.fallback.encode((Object)buf, (Object)value);
            return;
        }
        buf.method_10804(-1);
        buf.method_10812(customIngredient.getSerializer().getIdentifier());
        class_9139<class_9129, ?> packetCodec = customIngredient.getSerializer().getPacketCodec();
        packetCodec.encode((Object)buf, (Object)customIngredient);
    }

    static boolean shouldEncodeFallback(@Nullable CustomIngredient customIngredient) {
        if (customIngredient == null) {
            return true;
        }
        Set<class_2960> supportedIngredients = CustomIngredientSync.CURRENT_SUPPORTED_INGREDIENTS.get();
        return supportedIngredients != null && !supportedIngredients.contains(customIngredient.getSerializer().getIdentifier());
    }
}

