/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.sync;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.recipe.sync.RecipeSyncPayloadS2C;
import net.fabricmc.fabric.impl.recipe.sync.SupportedRecipeSerializersPayloadC2S;
import net.fabricmc.fabric.impl.recipe.sync.SyncedSerializerAwareClientConnection;
import net.fabricmc.fabric.impl.recipe.sync.SyncedSerializerAwarePreparedRecipe;
import net.fabricmc.fabric.mixin.recipe.sync.RecipeManagerAccessor;
import net.fabricmc.fabric.mixin.recipe.sync.ServerCommonPacketListenerImplAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class RecipeSyncImpl
implements ModInitializer {
    private static final int RECIPE_PAYLOAD_MAX_SIZE = 0x4000000;
    private static final Set<RecipeSerializer<?>> SYNCED_SERIALIZERS = new ReferenceOpenHashSet();
    public static final Identifier RECIPE_SYNC_EVENT_PHASE = Identifier.fromNamespaceAndPath((String)"fabric", (String)"recipe_sync");

    public void onInitialize() {
        PayloadTypeRegistry.configurationC2S().register(SupportedRecipeSerializersPayloadC2S.ID, SupportedRecipeSerializersPayloadC2S.CODEC);
        PayloadTypeRegistry.playS2C().registerLarge(RecipeSyncPayloadS2C.ID, RecipeSyncPayloadS2C.CODEC, 0x4000000);
        ServerConfigurationNetworking.registerGlobalReceiver(SupportedRecipeSerializersPayloadC2S.ID, RecipeSyncImpl::onRecipeSyncRequest);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(Event.DEFAULT_PHASE, RECIPE_SYNC_EVENT_PHASE);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(RECIPE_SYNC_EVENT_PHASE, RecipeSyncImpl::sendRecipes);
    }

    private static void onRecipeSyncRequest(SupportedRecipeSerializersPayloadC2S payload, ServerConfigurationNetworking.Context context) {
        ReferenceOpenHashSet set = new ReferenceOpenHashSet();
        for (Identifier identifier : payload.synchronizedSerializers()) {
            BuiltInRegistries.RECIPE_SERIALIZER.getOptional(identifier).ifPresent(arg_0 -> ((ReferenceOpenHashSet)set).add(arg_0));
        }
        ((SyncedSerializerAwareClientConnection)((ServerCommonPacketListenerImplAccessor)context.networkHandler()).getConnection()).fabric_setSyncedRecipeSerializers((Set<RecipeSerializer<?>>)set);
    }

    private static void sendRecipes(ServerPlayer player, boolean exist) {
        if (!ServerPlayNetworking.canSend((ServerPlayer)player, RecipeSyncPayloadS2C.ID)) {
            return;
        }
        Set<RecipeSerializer<?>> serializers = ((SyncedSerializerAwareClientConnection)((ServerCommonPacketListenerImplAccessor)player.connection).getConnection()).fabric_getSyncedRecipeSerializers();
        SyncedSerializerAwarePreparedRecipe accessor = (SyncedSerializerAwarePreparedRecipe)((RecipeManagerAccessor)player.level().recipeAccess()).getPreparedRecipes();
        ArrayList<RecipeSyncPayloadS2C.Entry> list = new ArrayList<RecipeSyncPayloadS2C.Entry>();
        for (RecipeSerializer<?> serializer : serializers) {
            List<RecipeHolder<?>> recipes = accessor.fabric_getRecipesBySyncedSerializer(serializer);
            if (recipes == null || recipes.isEmpty()) continue;
            list.add(new RecipeSyncPayloadS2C.Entry(serializer, recipes));
        }
        if (list.isEmpty()) {
            return;
        }
        ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new RecipeSyncPayloadS2C(list));
    }

    public static void addSynchronizedSerializer(RecipeSerializer<?> serializer) {
        SYNCED_SERIALIZERS.add(serializer);
    }

    public static boolean isSynced(RecipeSerializer<?> serializer) {
        return SYNCED_SERIALIZERS.contains(serializer);
    }

    public static Set<RecipeSerializer<?>> getSyncedSerializers() {
        return Collections.unmodifiableSet(SYNCED_SERIALIZERS);
    }
}

