/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.packet;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.impl.registry.sync.RegistryAttributeImpl;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record RegistrySyncPayload(Map<class_2960, Object2IntMap<class_2960>> registryMap, Map<class_2960, EnumSet<RegistryAttribute>> registryAttributes) implements class_8710
{
    public static final class_8710.class_9154<RegistrySyncPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"fabric", (String)"registry/sync"));
    public static final class_9139<class_2540, RegistrySyncPayload> CODEC = class_8710.method_56484(RegistrySyncPayload::write, RegistrySyncPayload::read);

    public RegistrySyncPayload(Map<class_2960, Object2IntMap<class_2960>> registryMap) {
        this(registryMap, RegistrySyncPayload.getRegistryAttributeMap(registryMap));
    }

    private static Map<class_2960, EnumSet<RegistryAttribute>> getRegistryAttributeMap(Map<class_2960, Object2IntMap<class_2960>> registryMap) {
        LinkedHashMap<class_2960, EnumSet<RegistryAttribute>> registryAttributes = new LinkedHashMap<class_2960, EnumSet<RegistryAttribute>>();
        registryMap.forEach((regId, idMap) -> {
            class_5321 registryKey = class_5321.method_29180((class_2960)regId);
            RegistryAttributeImpl holder = (RegistryAttributeImpl)RegistryAttributeHolder.get(registryKey);
            registryAttributes.put((class_2960)regId, holder.getAttributes());
        });
        return registryAttributes;
    }

    private static RegistrySyncPayload read(class_2540 combinedBuf) {
        LinkedHashMap<class_2960, Object2IntMap<class_2960>> syncedRegistryMap = new LinkedHashMap<class_2960, Object2IntMap<class_2960>>();
        LinkedHashMap<class_2960, EnumSet<RegistryAttribute>> syncedRegistryAttributes = new LinkedHashMap<class_2960, EnumSet<RegistryAttribute>>();
        int regNamespaceGroupAmount = combinedBuf.method_10816();
        for (int i = 0; i < regNamespaceGroupAmount; ++i) {
            String regNamespace = RegistrySyncPayload.unoptimizeNamespace(combinedBuf.method_19772());
            int regNamespaceGroupLength = combinedBuf.method_10816();
            for (int j = 0; j < regNamespaceGroupLength; ++j) {
                String regPath = combinedBuf.method_19772();
                EnumSet<RegistryAttribute> attributes = RegistrySyncPayload.decodeRegistryAttributes(combinedBuf.readByte());
                Object2IntLinkedOpenHashMap idMap = new Object2IntLinkedOpenHashMap();
                int idNamespaceGroupAmount = combinedBuf.method_10816();
                int lastBulkLastRawId = 0;
                for (int k = 0; k < idNamespaceGroupAmount; ++k) {
                    String idNamespace = RegistrySyncPayload.unoptimizeNamespace(combinedBuf.method_19772());
                    int rawIdBulkAmount = combinedBuf.method_10816();
                    for (int l = 0; l < rawIdBulkAmount; ++l) {
                        int bulkRawIdStartDiff = combinedBuf.method_10816();
                        int bulkSize = combinedBuf.method_10816();
                        int currentRawId = lastBulkLastRawId + bulkRawIdStartDiff - 1;
                        for (int m = 0; m < bulkSize; ++m) {
                            String idPath = combinedBuf.method_19772();
                            idMap.put((Object)class_2960.method_60655((String)idNamespace, (String)idPath), ++currentRawId);
                        }
                        lastBulkLastRawId = currentRawId;
                    }
                }
                class_2960 registryId = class_2960.method_60655((String)regNamespace, (String)regPath);
                syncedRegistryMap.put(registryId, (Object2IntMap<class_2960>)idMap);
                syncedRegistryAttributes.put(registryId, attributes);
            }
        }
        return new RegistrySyncPayload(syncedRegistryMap, syncedRegistryAttributes);
    }

    private void write(class_2540 buf) {
        Map<String, List<class_2960>> regNamespaceGroups = this.registryMap.keySet().stream().collect(Collectors.groupingBy(class_2960::method_12836));
        buf.method_10804(regNamespaceGroups.size());
        regNamespaceGroups.forEach((regNamespace, regIds) -> {
            buf.method_10814(RegistrySyncPayload.optimizeNamespace(regNamespace));
            buf.method_10804(regIds.size());
            for (class_2960 regId : regIds) {
                buf.method_10814(regId.method_12832());
                buf.method_52997((int)RegistrySyncPayload.encodeRegistryAttributes(this.registryAttributes.getOrDefault(regId, EnumSet.noneOf(RegistryAttribute.class))));
                Object2IntMap<class_2960> idMap = this.registryMap.get(regId);
                Map idNamespaceGroups = idMap.object2IntEntrySet().stream().collect(Collectors.groupingBy(e -> ((class_2960)e.getKey()).method_12836(), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
                buf.method_10804(idNamespaceGroups.size());
                int lastBulkLastRawId = 0;
                for (Map.Entry idNamespaceEntry : idNamespaceGroups.entrySet()) {
                    List idPairs = (List)idNamespaceEntry.getValue();
                    idPairs.sort(Comparator.comparingInt(Object2IntMap.Entry::getIntValue));
                    ArrayList bulks = new ArrayList();
                    Iterator idPairIter = idPairs.iterator();
                    ArrayList<Object2IntMap.Entry> currentBulk = new ArrayList<Object2IntMap.Entry>();
                    Object2IntMap.Entry currentPair = (Object2IntMap.Entry)idPairIter.next();
                    currentBulk.add(currentPair);
                    while (idPairIter.hasNext()) {
                        currentPair = (Object2IntMap.Entry)idPairIter.next();
                        if (((Object2IntMap.Entry)currentBulk.get(currentBulk.size() - 1)).getIntValue() + 1 != currentPair.getIntValue()) {
                            bulks.add(currentBulk);
                            currentBulk = new ArrayList();
                        }
                        currentBulk.add(currentPair);
                    }
                    bulks.add(currentBulk);
                    buf.method_10814(RegistrySyncPayload.optimizeNamespace((String)idNamespaceEntry.getKey()));
                    buf.method_10804(bulks.size());
                    for (List list : bulks) {
                        int firstRawId = ((Object2IntMap.Entry)list.get(0)).getIntValue();
                        int bulkRawIdStartDiff = firstRawId - lastBulkLastRawId;
                        buf.method_10804(bulkRawIdStartDiff);
                        buf.method_10804(list.size());
                        for (Object2IntMap.Entry idPair : list) {
                            buf.method_10814(((class_2960)idPair.getKey()).method_12832());
                            lastBulkLastRawId = idPair.getIntValue();
                        }
                    }
                }
            }
        });
    }

    private static byte encodeRegistryAttributes(EnumSet<RegistryAttribute> attributes) {
        byte encoded = 0;
        if (attributes.contains((Object)RegistryAttribute.OPTIONAL)) {
            encoded = (byte)(encoded | 1);
        }
        return encoded;
    }

    private static EnumSet<RegistryAttribute> decodeRegistryAttributes(byte encoded) {
        EnumSet<RegistryAttribute> attributes = EnumSet.noneOf(RegistryAttribute.class);
        if ((encoded & 1) != 0) {
            attributes.add(RegistryAttribute.OPTIONAL);
        }
        return attributes;
    }

    private static String optimizeNamespace(String namespace) {
        return namespace.equals("minecraft") ? "" : namespace;
    }

    private static String unoptimizeNamespace(String namespace) {
        return namespace.isEmpty() ? "minecraft" : namespace;
    }

    public class_8710.class_9154<RegistrySyncPayload> method_56479() {
        return ID;
    }
}

