/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.render;

import java.util.function.Predicate;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10515;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_9891;

/**
 * Note: This interface is automatically implemented on {@link class_776} via Mixin and interface injection.
 */
public interface FabricBlockRenderManager {
	/**
	 * Alternative for
	 * {@link class_776#method_3353(class_2680, class_4587, class_4597, int, int)} that
	 * additionally accepts the {@link class_1920} and {@link class_2338} to pass to
	 * {@link class_1087#emitQuads(QuadEmitter, class_1920, class_2338, class_2680, class_5819, Predicate)} when
	 * necessary. <b>Prefer using this method over the vanilla alternative to correctly buffer models that have geometry
	 * on multiple render layers and to provide the model with additional context.</b>
	 *
	 * <p>This method allows buffering a block model with minimal transformations to the model geometry. Also invokes
	 * the {@link class_10515}. Usually used by entity renderers.
	 *
	 * @param state The block state.
	 * @param matrices The matrices.
	 * @param vertexConsumers The vertex consumers.
	 * @param light The minimum light value.
	 * @param overlay The overlay value.
	 * @param blockView The world in which to render the model. <b>Can be empty (i.e. {@link class_9891}).</b>
	 * @param pos The position of the block in the world. <b>Should be {@link class_2338#field_10980} if the world is empty.
	 *            </b>
	 */
	default void renderBlockAsEntity(class_2680 state, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1920 blockView, class_2338 pos) {
		Renderer.get().renderBlockAsEntity((class_776) this, state, matrices, vertexConsumers, light, overlay, blockView, pos);
	}
}
