/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.model;

import java.util.List;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.minecraft.class_10419;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_10820;
import net.minecraft.class_3665;
import net.minecraft.class_777;
import net.minecraft.class_7775;

/**
 * A special {@link class_10817} which hides a {@link Mesh} instead of using {@link class_777}s. Useful for custom
 * implementations of {@link class_10820#bake(class_10419, class_7775, class_3665, class_10813)} that want to return a
 * mesh. Instances of this class always return empty lists from inherited methods.
 *
 * <p>Any code that interacts with {@link class_10817} should first check {@code instanceof MeshBakedGeometry} and use
 * {@link #getMesh()} if {@code true} or the vanilla methods otherwise.
 */
public final class MeshBakedGeometry extends class_10817 {
	private final Mesh mesh;

	public MeshBakedGeometry(Mesh mesh) {
		super(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
		this.mesh = mesh;
	}

	/**
	 * Gets this geometry's mesh. Always use this method instead of vanilla methods when available.
	 */
	public Mesh getMesh() {
		return mesh;
	}
}
