/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.fabric.api.renderer.v1.render.BlockVertexConsumerProvider;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_761;

/**
 * Used during terrain-like block buffering to invoke {@link class_1087#emitQuads}.
 */
public class TerrainLikeRenderContext extends AbstractTerrainRenderContext {
	public static final ThreadLocal<TerrainLikeRenderContext> POOL = ThreadLocal.withInitial(TerrainLikeRenderContext::new);

	private final class_5819 random = class_5819.method_43053();

	private BlockVertexConsumerProvider vertexConsumers;

	@Override
	protected LightDataProvider createLightDataProvider(BlockRenderInfo blockInfo) {
		// TODO: Use a cache whenever vanilla would use a cache (BrightnessCache.enabled)
		return new LightDataProvider() {
			@Override
			public int light(class_2338 pos, class_2680 state) {
				return class_761.method_23793(class_761.class_10948.field_58200, blockInfo.blockView, state, pos);
			}

			@Override
			public float ao(class_2338 pos, class_2680 state) {
				return AoLuminanceFix.INSTANCE.apply(blockInfo.blockView, pos, state);
			}
		};
	}

	@Override
	protected class_4588 getVertexConsumer(class_11515 layer) {
		return vertexConsumers.getBuffer(layer);
	}

	public void bufferModel(class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrixStack, BlockVertexConsumerProvider vertexConsumers, boolean cull, long seed, int overlay) {
		try {
			class_243 offset = state.method_26226(pos);
			matrixStack.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
			matrices = matrixStack.method_23760();
			this.overlay = overlay;

			this.vertexConsumers = vertexConsumers;

			blockInfo.prepareForWorld(blockView, cull);
			random.method_43052(seed);

			prepare(pos, state);
			model.emitQuads(getEmitter(), blockView, pos, state, random, blockInfo::shouldCullSide);
		} catch (Throwable throwable) {
			class_128 crashReport = class_128.method_560(throwable, "Tessellating block model - Indigo Renderer");
			class_129 crashReportSection = crashReport.method_562("Block model being tessellated");
			class_129.method_586(crashReportSection, blockView, pos, state);
			throw new class_148(crashReport);
		} finally {
			blockInfo.release();
			matrices = null;
			this.vertexConsumers = null;
		}
	}
}
