/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering.fluid;

import java.util.IdentityHashMap;
import java.util.Map;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10725;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2397;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_775;

public class FluidRenderHandlerRegistryImpl implements FluidRenderHandlerRegistry {
	private final Map<class_3611, FluidRenderHandler> handlers = new IdentityHashMap<>();
	private final Map<class_3611, FluidRenderHandler> modHandlers = new IdentityHashMap<>();
	private final Object2BooleanMap<class_2248> transparencyForOverlay = new Object2BooleanOpenHashMap<>();

	{
		handlers.put(class_3612.field_15910, WaterRenderHandler.INSTANCE);
		handlers.put(class_3612.field_15909, WaterRenderHandler.INSTANCE);
		handlers.put(class_3612.field_15908, LavaRenderHandler.INSTANCE);
		handlers.put(class_3612.field_15907, LavaRenderHandler.INSTANCE);
	}

	public FluidRenderHandlerRegistryImpl() {
	}

	@Override
	@Nullable
	public FluidRenderHandler get(class_3611 fluid) {
		return handlers.get(fluid);
	}

	@Override
	@Nullable
	public FluidRenderHandler getOverride(class_3611 fluid) {
		return modHandlers.get(fluid);
	}

	@Override
	public void register(class_3611 fluid, FluidRenderHandler renderer) {
		handlers.put(fluid, renderer);
		modHandlers.put(fluid, renderer);
	}

	@Override
	public void setBlockTransparency(class_2248 block, boolean transparent) {
		transparencyForOverlay.put(block, transparent);
	}

	@Override
	public boolean isBlockTransparent(class_2248 block) {
		return transparencyForOverlay.getOrDefault(block, block instanceof class_2373 || block instanceof class_2397);
	}

	public void onFluidRendererReload(class_775 renderer, class_1058[] waterSprites, class_1058[] lavaSprites, class_1058 waterOverlay) {
		FluidRenderingImpl.setVanillaRenderer(renderer);

		WaterRenderHandler.INSTANCE.updateSprites(waterSprites, waterOverlay);
		LavaRenderHandler.INSTANCE.updateSprites(lavaSprites);

		class_1059 texture = class_310.method_1551()
				.method_72703()
				.method_73025(class_10725.field_56382);

		for (FluidRenderHandler handler : handlers.values()) {
			handler.reloadTextures(texture);
		}
	}

	private static class WaterRenderHandler implements FluidRenderHandler {
		public static final WaterRenderHandler INSTANCE = new WaterRenderHandler();

		/**
		 * The water color of {@link class_1972#field_9423}.
		 */
		private static final int DEFAULT_WATER_COLOR = 0x3f76e4;

		private final class_1058[] sprites = new class_1058[3];

		@Override
		public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
			return sprites;
		}

		@Override
		public int getFluidColor(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
			if (view != null && pos != null) {
				return class_1163.method_4961(view, pos);
			} else {
				return DEFAULT_WATER_COLOR;
			}
		}

		public void updateSprites(class_1058[] waterSprites, class_1058 waterOverlay) {
			sprites[0] = waterSprites[0];
			sprites[1] = waterSprites[1];
			sprites[2] = waterOverlay;
		}
	}

	private static class LavaRenderHandler implements FluidRenderHandler {
		public static final LavaRenderHandler INSTANCE = new LavaRenderHandler();

		private class_1058[] sprites;

		@Override
		public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
			return sprites;
		}

		public void updateSprites(class_1058[] lavaSprites) {
			sprites = lavaSprites;
		}
	}
}
