/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.loader.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Options;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Options.class})
public class OptionsMixin {
    @Shadow
    public List<String> resourcePacks;
    @Shadow
    @Final
    static Logger LOGGER;

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo ci) {
        Path dataDir = FabricLoader.getInstance().getGameDir().resolve("data");
        if (Files.notExists(dataDir, new LinkOption[0])) {
            try {
                Files.createDirectories(dataDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.warn("[Fabric Resource Loader] Could not create data directory: " + String.valueOf(dataDir.toAbsolutePath()));
            }
        }
        Path trackerFile = dataDir.resolve("fabricDefaultResourcePacks.dat");
        HashSet<String> trackedPacks = new HashSet<String>();
        if (Files.exists(trackerFile, new LinkOption[0])) {
            try {
                CompoundTag data = NbtIo.readCompressed((Path)trackerFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
                ListTag values = (ListTag)data.getList("values").orElseThrow();
                for (int i = 0; i < values.size(); ++i) {
                    trackedPacks.add((String)values.getString(i).orElseThrow());
                }
            }
            catch (IOException e) {
                LOGGER.warn("[Fabric Resource Loader] Could not read " + String.valueOf(trackerFile.toAbsolutePath()), (Throwable)e);
            }
        }
        HashSet removedPacks = new HashSet(trackedPacks);
        LinkedHashSet<String> resourcePacks = new LinkedHashSet<String>(this.resourcePacks);
        ArrayList profiles = new ArrayList();
        ModResourcePackCreator.CLIENT_RESOURCE_PACK_PROVIDER.loadPacks(profiles::add);
        for (Object profile : profiles) {
            if (profile.getId().equals("fabric")) {
                resourcePacks.add(profile.getId());
                continue;
            }
            PackResources pack = profile.open();
            try {
                ModNioResourcePack builtinPack;
                if (!(pack instanceof ModNioResourcePack) || !(builtinPack = (ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) continue;
                if (trackedPacks.add(builtinPack.packId())) {
                    resourcePacks.add(profile.getId());
                    continue;
                }
                removedPacks.remove(builtinPack.packId());
            }
            finally {
                if (pack == null) continue;
                pack.close();
            }
        }
        try {
            ListTag values = new ListTag();
            for (String id : trackedPacks) {
                if (removedPacks.contains(id)) continue;
                values.add((Object)StringTag.valueOf((String)id));
            }
            CompoundTag nbt = new CompoundTag();
            nbt.put("values", (Tag)values);
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)trackerFile);
        }
        catch (IOException e) {
            LOGGER.warn("[Fabric Resource Loader] Could not write to " + String.valueOf(trackerFile.toAbsolutePath()), (Throwable)e);
        }
        this.resourcePacks = new ArrayList<String>(resourcePacks);
    }

    @WrapOperation(method={"updateResourcePacks"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/packs/repository/Pack;isFixedPosition()Z")})
    private boolean excludeInternalResourcePacksFromRefreshCheck(Pack instance, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{instance}) != false || ((FabricResourcePackProfile)instance).fabric_isHidden();
    }
}

