/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.resource.v1;

import java.util.List;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import net.fabricmc.fabric.impl.resource.v1.FabricLifecycledResourceManager;
import net.fabricmc.fabric.impl.resource.v1.ResourceLoaderImpl;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4014;

@Mixin(class_4014.class)
public class SimpleReloadInstanceMixin {
	@ModifyArg(
			method = "create(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/server/packs/resources/ReloadInstance;",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/server/packs/resources/SimpleReloadInstance;of(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;)Lnet/minecraft/server/packs/resources/ReloadInstance;"
			)
	)
	private static List<class_3302> sortSimple(List<class_3302> reloaders, @Local(argsOnly = true) class_3300 resourceManager) {
		if (resourceManager instanceof FabricLifecycledResourceManager flrm) {
			return ResourceLoaderImpl.sort(flrm.fabric$getResourceType(), reloaders);
		}

		return reloaders;
	}

	@ModifyArg(
			method = "create(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/server/packs/resources/ReloadInstance;",
			at = @At(
					value = "INVOKE",
					target = "Lnet/minecraft/server/packs/resources/ProfiledReloadInstance;of(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;)Lnet/minecraft/server/packs/resources/ReloadInstance;"
			)
	)
	private static List<class_3302> sortProfiled(List<class_3302> reloaders, @Local(argsOnly = true) class_3300 resourceManager) {
		if (resourceManager instanceof FabricLifecycledResourceManager flrm) {
			return ResourceLoaderImpl.sort(flrm.fabric$getResourceType(), reloaders);
		}

		return reloaders;
	}

	@ModifyVariable(
			method = "create(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/List;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Ljava/util/concurrent/CompletableFuture;Z)Lnet/minecraft/server/packs/resources/ReloadInstance;",
			at = @At(value = "LOAD", ordinal = 0),
			argsOnly = true
	)
	private static boolean adjustProfiledCheck(boolean profiled) {
		return profiled || ResourceLoaderImpl.DEBUG_PROFILE_RESOURCE_RELOADERS;
	}
}
