/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.screenhandler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1703;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Networking
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-screen-handler-api-v1/server");
    public static final class_2960 OPEN_ID = class_2960.method_60655((String)"fabric-screen-handler-api-v1", (String)"open_screen");
    public static final Map<class_2960, class_9139<? super class_9129, ?>> CODEC_BY_ID = new HashMap();

    public static <D> void sendOpenPacket(class_3222 player, ExtendedScreenHandlerFactory<D> factory, class_1703 handler, int syncId) {
        Objects.requireNonNull(player, "player is null");
        Objects.requireNonNull(factory, "factory is null");
        Objects.requireNonNull(handler, "handler is null");
        class_2960 typeId = class_7923.field_41187.method_10221((Object)handler.method_17358());
        if (typeId == null) {
            LOGGER.warn("Trying to open unregistered screen handler {}", (Object)handler);
            return;
        }
        class_9139<? super class_9129, ?> codec = Objects.requireNonNull(CODEC_BY_ID.get(typeId), () -> "Codec for " + String.valueOf(typeId) + " is not registered!");
        D data = factory.getScreenOpeningData(player);
        ServerPlayNetworking.send((class_3222)player, new OpenScreenPayload(typeId, syncId, factory.method_5476(), codec, data));
    }

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(OpenScreenPayload.ID, OpenScreenPayload.CODEC);
        Networking.forEachEntry(class_7923.field_41187, (type, id) -> {
            if (type instanceof ExtendedScreenHandlerType) {
                ExtendedScreenHandlerType extended = (ExtendedScreenHandlerType)((Object)type);
                CODEC_BY_ID.put((class_2960)id, extended.getPacketCodec());
            }
        });
    }

    private static <T> void forEachEntry(class_2378<T> registry, BiConsumer<T, class_2960> consumer) {
        for (Object type2 : registry) {
            consumer.accept(type2, registry.method_10221(type2));
        }
        RegistryEntryAddedCallback.event(registry).register((rawId, id, type) -> consumer.accept(type, id));
    }

    public record OpenScreenPayload<D>(class_2960 identifier, int syncId, class_2561 title, class_9139<class_9129, D> innerCodec, D data) implements class_8710
    {
        public static final class_9139<class_9129, OpenScreenPayload<?>> CODEC = class_8710.method_56484(OpenScreenPayload::write, OpenScreenPayload::fromBuf);
        public static final class_8710.class_9154<OpenScreenPayload<?>> ID = new class_8710.class_9154(OPEN_ID);

        private static <D> OpenScreenPayload<D> fromBuf(class_9129 buf) {
            class_2960 id = buf.method_10810();
            class_9139<? super class_9129, ?> codec = CODEC_BY_ID.get(id);
            return new OpenScreenPayload<Object>(id, buf.readByte(), (class_2561)class_8824.field_48540.decode((Object)buf), (class_9139<class_9129, Object>)codec, (codec == null ? null : codec.decode((Object)buf)));
        }

        private void write(class_9129 buf) {
            buf.method_10812(this.identifier);
            buf.method_52997(this.syncId);
            class_8824.field_48540.encode((Object)buf, (Object)this.title);
            this.innerCodec.encode((Object)buf, this.data);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

