/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.fluid;

import java.util.Optional;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.impl.transfer.TransferApiImpl;
import net.minecraft.class_12206;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

public final class FluidVariantAttributes {
    private static final ApiProviderMap<class_3611, FluidVariantAttributeHandler> HANDLERS = ApiProviderMap.create();
    private static final FluidVariantAttributeHandler DEFAULT_HANDLER = new FluidVariantAttributeHandler(){};
    private static volatile boolean coloredVanillaFluidNames = false;

    private FluidVariantAttributes() {
    }

    public static void register(class_3611 fluid, FluidVariantAttributeHandler handler) {
        if (HANDLERS.putIfAbsent((Object)fluid, (Object)handler) != null) {
            throw new IllegalArgumentException("Duplicate handler registration for fluid " + String.valueOf(fluid));
        }
    }

    public static void enableColoredVanillaFluidNames() {
        coloredVanillaFluidNames = true;
    }

    @Nullable
    public static FluidVariantAttributeHandler getHandler(class_3611 fluid) {
        return (FluidVariantAttributeHandler)HANDLERS.get((Object)fluid);
    }

    public static FluidVariantAttributeHandler getHandlerOrDefault(class_3611 fluid) {
        FluidVariantAttributeHandler handler = (FluidVariantAttributeHandler)HANDLERS.get((Object)fluid);
        return handler == null ? DEFAULT_HANDLER : handler;
    }

    public static class_2561 getName(FluidVariant variant) {
        return FluidVariantAttributes.getHandlerOrDefault(variant.getFluid()).getName(variant);
    }

    public static class_3414 getFillSound(FluidVariant variant) {
        return FluidVariantAttributes.getHandlerOrDefault(variant.getFluid()).getFillSound(variant).or(() -> variant.getFluid().method_32359()).orElse(class_3417.field_15126);
    }

    public static class_3414 getEmptySound(FluidVariant variant) {
        return FluidVariantAttributes.getHandlerOrDefault(variant.getFluid()).getEmptySound(variant).orElse(class_3417.field_14834);
    }

    public static int getLuminance(FluidVariant variant) {
        int luminance = FluidVariantAttributes.getHandlerOrDefault(variant.getFluid()).getLuminance(variant);
        if (luminance < 0 || luminance > 15) {
            TransferApiImpl.LOGGER.warn("Broken FluidVariantAttributeHandler. Invalid luminance %d for fluid variant %s".formatted(luminance, variant));
            return DEFAULT_HANDLER.getLuminance(variant);
        }
        return luminance;
    }

    public static int getTemperature(FluidVariant variant) {
        int temperature = FluidVariantAttributes.getHandlerOrDefault(variant.getFluid()).getTemperature(variant);
        if (temperature < 0) {
            TransferApiImpl.LOGGER.warn("Broken FluidVariantAttributeHandler. Invalid temperature %d for fluid variant %s".formatted(temperature, variant));
            return DEFAULT_HANDLER.getTemperature(variant);
        }
        return temperature;
    }

    public static int getViscosity(FluidVariant variant, @Nullable class_1937 world) {
        int viscosity = FluidVariantAttributes.getHandlerOrDefault(variant.getFluid()).getViscosity(variant, world);
        if (viscosity <= 0) {
            TransferApiImpl.LOGGER.warn("Broken FluidVariantAttributeHandler. Invalid viscosity %d for fluid variant %s".formatted(viscosity, variant));
            return DEFAULT_HANDLER.getViscosity(variant, world);
        }
        return viscosity;
    }

    public static boolean isLighterThanAir(FluidVariant variant) {
        return FluidVariantAttributes.getHandlerOrDefault(variant.getFluid()).isLighterThanAir(variant);
    }

    static {
        FluidVariantAttributes.register((class_3611)class_3612.field_15910, new FluidVariantAttributeHandler(){

            @Override
            public class_2561 getName(FluidVariant fluidVariant) {
                if (coloredVanillaFluidNames) {
                    return class_2246.field_10382.method_9518().method_10862(class_2583.field_24360.method_10977(class_124.field_1078));
                }
                return FluidVariantAttributeHandler.super.getName(fluidVariant);
            }

            @Override
            public Optional<class_3414> getEmptySound(FluidVariant variant) {
                return Optional.of(class_3417.field_14834);
            }
        });
        FluidVariantAttributes.register((class_3611)class_3612.field_15908, new FluidVariantAttributeHandler(){

            @Override
            public class_2561 getName(FluidVariant fluidVariant) {
                if (coloredVanillaFluidNames) {
                    return class_2246.field_10164.method_9518().method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
                }
                return FluidVariantAttributeHandler.super.getName(fluidVariant);
            }

            @Override
            public Optional<class_3414> getFillSound(FluidVariant variant) {
                return Optional.of(class_3417.field_15202);
            }

            @Override
            public Optional<class_3414> getEmptySound(FluidVariant variant) {
                return Optional.of(class_3417.field_15010);
            }

            @Override
            public int getTemperature(FluidVariant variant) {
                return 1300;
            }

            @Override
            public int getViscosity(FluidVariant variant, @Nullable class_1937 world) {
                if (world != null && ((Boolean)world.method_75728().method_75694(class_12206.field_63759)).booleanValue()) {
                    return 2000;
                }
                return 6000;
            }
        });
    }
}

