/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.transfer;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantCache;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.minecraft.class_1792;
import net.minecraft.class_9326;

/**
 * Cache the ItemVariant with a null tag inside each Item directly.
 */
@Mixin(class_1792.class)
public class ItemMixin implements ItemVariantCache {
	@Unique
	@SuppressWarnings("ConstantConditions")
	private final ItemVariant cachedItemVariant = new ItemVariantImpl((class_1792) (Object) this, class_9326.field_49588);

	@Override
	public ItemVariant fabric_getCachedItemVariant() {
		return cachedItemVariant;
	}
}
