/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class CursorSlotWrapper
extends SingleStackStorage {
    private static final Map<AbstractContainerMenu, CursorSlotWrapper> WRAPPERS = new MapMaker().weakValues().makeMap();
    private final AbstractContainerMenu screenHandler;

    public static CursorSlotWrapper get(AbstractContainerMenu screenHandler) {
        return WRAPPERS.computeIfAbsent(screenHandler, CursorSlotWrapper::new);
    }

    private CursorSlotWrapper(AbstractContainerMenu screenHandler) {
        this.screenHandler = screenHandler;
    }

    @Override
    protected ItemStack getStack() {
        return this.screenHandler.getCarried();
    }

    @Override
    protected void setStack(ItemStack stack) {
        this.screenHandler.setCarried(stack);
    }

    @Override
    public String toString() {
        return "CursorSlotWrapper[" + String.valueOf(this.screenHandler) + "/" + String.valueOf(BuiltInRegistries.MENU.getKey((Object)this.screenHandler.getType())) + "]";
    }
}

