/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.fabricmc.loom.configuration.classpathgroups.ExternalClasspathGroup;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.gradle.SourceSetReference;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.ApiStatus;

public abstract class ModSettings
implements Named {
    public abstract ConfigurableFileCollection getModFiles();

    @Inject
    public ModSettings() {
        this.getExternalGroups().finalizeValueOnRead();
        this.getModFiles().finalizeValueOnRead();
    }

    public void sourceSet(SourceSet sourceSet) {
        Project project = this.getProject();
        if (!SourceSetHelper.isSourceSetOfProject(sourceSet, project)) {
            this.getProject().getLogger().info("Computing owner project for SourceSet {} as it is not a sourceset of {}", (Object)sourceSet.getName(), (Object)project.getPath());
            project = SourceSetHelper.getSourceSetProject(sourceSet);
            if (project == this.getProject()) {
                throw new IllegalStateException("isSourceSetOfProject lied, report to loom devs.");
            }
        }
        this.sourceSet(sourceSet, project);
    }

    public void sourceSet(String name) {
        this.sourceSet(name, this.getProject());
    }

    @Deprecated
    public void sourceSet(SourceSet sourceSet, Project project) {
        this.ensureCompanion(project);
        this.sourceSet(sourceSet.getName(), project.getPath());
    }

    @Deprecated
    public void sourceSet(String name, Project project) {
        this.ensureCompanion(project);
        this.sourceSet(name, project.getPath());
    }

    public void sourceSet(String sourceSetName, String projectPath) {
        if (projectPath.equals(this.getProject().getPath())) {
            SourceSetReference ref = new SourceSetReference(SourceSetHelper.getSourceSetByName(sourceSetName, this.getProject()), this.getProject());
            List<File> classpath = SourceSetHelper.getClasspath(ref);
            this.getModFiles().from(new Object[]{classpath});
            return;
        }
        this.getExternalGroups().add((Object)new ExternalClasspathGroup(projectPath, sourceSetName));
    }

    public void dependency(Dependency ... dependencies) {
        Configuration detachedConfiguration = this.getProject().getConfigurations().detachedConfiguration(dependencies);
        this.configuration(detachedConfiguration);
    }

    public void configuration(Configuration configuration) {
        this.getModFiles().from(new Object[]{configuration});
    }

    @ApiStatus.Internal
    public abstract ListProperty<ExternalClasspathGroup> getExternalGroups();

    @Inject
    public abstract Project getProject();

    public String toString() {
        return "ModSettings '" + this.getName() + "'";
    }

    private void ensureCompanion(Project project) {
        if (project == this.getProject()) {
            return;
        }
        project.apply(Map.of("plugin", "net.fabricmc.fabric-loom-companion"));
    }
}

