/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.classpathgroups;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.gradle.SourceSetReference;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public record ExternalClasspathGroupDTO(String projectPath, Map<String, List<String>> classpaths) implements Serializable
{
    public static ExternalClasspathGroupDTO createFromProject(Project project) {
        SourceSetContainer sourceSets = SourceSetHelper.getSourceSets(project);
        HashMap<String, List<String>> classpaths = new HashMap<String, List<String>>();
        for (SourceSet sourceSet : sourceSets) {
            SourceSetReference ref = new SourceSetReference(sourceSet, project);
            List<File> classpath = SourceSetHelper.getClasspath(ref);
            classpaths.put(sourceSet.getName(), classpath.stream().map(File::getAbsolutePath).toList());
        }
        return new ExternalClasspathGroupDTO(project.getPath(), Collections.unmodifiableMap(classpaths));
    }

    public static Map<String, ExternalClasspathGroupDTO> resolveExternal(Set<File> files) {
        HashMap<String, ExternalClasspathGroupDTO> map = new HashMap<String, ExternalClasspathGroupDTO>();
        for (File file : files) {
            String json;
            try {
                json = Files.readString(file.toPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read external classpath group file: " + String.valueOf(file), e);
            }
            ExternalClasspathGroupDTO dto = (ExternalClasspathGroupDTO)LoomGradlePlugin.GSON.fromJson(json, ExternalClasspathGroupDTO.class);
            map.put(dto.projectPath(), dto);
        }
        return Collections.unmodifiableMap(map);
    }

    public List<String> getForSourceSet(String sourceSetName) {
        return Objects.requireNonNull(this.classpaths.get(sourceSetName), "No classpath found for source set: " + sourceSetName);
    }
}

