/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.library.processors;

import java.util.List;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessor;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.artifacts.dsl.RepositoryHandler;

public class LWJGL2MavenLibraryProcessor
extends LibraryProcessor {
    private static final List<String> LWJGL_LIST = List.of("org.lwjgl.lwjgl:lwjgl:2.9.1-nightly-20130708-debug3", "org.lwjgl.lwjgl:lwjgl:2.9.1-nightly-20131017");

    public LWJGL2MavenLibraryProcessor(Platform platform, LibraryContext context) {
        super(platform, context);
    }

    @Override
    public LibraryProcessor.ApplicationResult getApplicationResult() {
        if (this.context.usesLWJGL3()) {
            return LibraryProcessor.ApplicationResult.DONT_APPLY;
        }
        return LWJGL_LIST.stream().anyMatch(this.context::hasLibrary) ? LibraryProcessor.ApplicationResult.MUST_APPLY : LibraryProcessor.ApplicationResult.DONT_APPLY;
    }

    @Override
    public void applyRepositories(RepositoryHandler repositories) {
        LoomRepositoryPlugin.setupForLegacyVersions(repositories);
    }
}

