/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

public abstract class LegacyJarProcessorWrapper
implements MinecraftJarProcessor<Spec> {
    private final JarProcessor delegate;

    @Inject
    public LegacyJarProcessorWrapper(JarProcessor delegate) {
        this.delegate = delegate;
    }

    @Inject
    public abstract Project getProject();

    public String getName() {
        return "legacy:" + this.delegate.getClass().getCanonicalName();
    }

    @Override
    @Nullable
    public Spec buildSpec(SpecContext context) {
        this.delegate.setup();
        return new Spec(this.delegate.getId());
    }

    @Override
    public void processJar(Path jar, Spec spec, ProcessorContext context) throws IOException {
        this.delegate.process(jar.toFile());
    }

    public record Spec(String cacheValue) implements MinecraftJarProcessor.Spec
    {
    }
}

