/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.tiny;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import org.jetbrains.annotations.Nullable;

public final class UnobfuscatedMappingNsCompleter
extends ForwardingMappingVisitor {
    private final String testNs;
    private final Map<String, String> alternatives;
    private int testNsId;
    private int[] alternativesMapping;
    private String srcName;
    private String[] dstNames;
    private boolean[] unobf;
    private boolean[] lastMethodUnobf;
    private boolean relayHeaderOrMetadata;

    public UnobfuscatedMappingNsCompleter(MappingVisitor next, String testNs, Map<String, String> alternatives) {
        super(next);
        this.testNs = testNs;
        this.alternatives = alternatives;
    }

    public boolean visitHeader() throws IOException {
        this.relayHeaderOrMetadata = this.next.visitHeader();
        return true;
    }

    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        int count = dstNamespaces.size();
        this.testNsId = -1;
        this.alternativesMapping = new int[count];
        this.dstNames = new String[count];
        this.unobf = new boolean[count + 1];
        this.lastMethodUnobf = new boolean[count + 1];
        for (int i = 0; i < count; ++i) {
            int srcIdx;
            String src;
            String dst = dstNamespaces.get(i);
            if (this.testNs.equals(dst)) {
                this.testNsId = i;
            }
            if ((src = this.alternatives.get(dst)) == null) {
                srcIdx = i;
            } else if (src.equals(srcNamespace)) {
                srcIdx = -1;
            } else {
                srcIdx = dstNamespaces.indexOf(src);
                if (srcIdx < 0) {
                    throw new RuntimeException("invalid alternative mapping ns " + src + ": not in " + String.valueOf(dstNamespaces) + " or " + srcNamespace);
                }
            }
            this.alternativesMapping[i] = srcIdx;
        }
        if (this.testNsId == -1 && !this.testNs.equals(srcNamespace)) {
            throw new RuntimeException("test namespace " + this.testNs + " not present in src and dst namespaces!");
        }
        if (this.relayHeaderOrMetadata) {
            this.next.visitNamespaces(srcNamespace, dstNamespaces);
        }
    }

    public void visitMetadata(String key, @Nullable String value) throws IOException {
        if (this.relayHeaderOrMetadata) {
            this.next.visitMetadata(key, value);
        }
    }

    public boolean visitContent() throws IOException {
        this.relayHeaderOrMetadata = true;
        return this.next.visitContent();
    }

    public boolean visitClass(String srcName) throws IOException {
        this.srcName = srcName;
        return this.next.visitClass(srcName);
    }

    public boolean visitField(String srcName, @Nullable String srcDesc) throws IOException {
        this.srcName = srcName;
        return this.next.visitField(srcName, srcDesc);
    }

    public boolean visitMethod(String srcName, @Nullable String srcDesc) throws IOException {
        this.srcName = srcName;
        return this.next.visitMethod(srcName, srcDesc);
    }

    public boolean visitMethodArg(int argPosition, int lvIndex, @Nullable String srcName) throws IOException {
        this.srcName = srcName;
        return this.next.visitMethodArg(argPosition, lvIndex, srcName);
    }

    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName) throws IOException {
        this.srcName = srcName;
        return this.next.visitMethodVar(lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName);
    }

    public void visitDstName(MappedElementKind targetKind, int namespace, String name) {
        this.dstNames[namespace] = name;
    }

    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        for (int ns : this.alternativesMapping) {
            int idx = ns + 1;
            if (targetKind == MappedElementKind.METHOD_ARG || targetKind == MappedElementKind.METHOD_VAR) {
                this.unobf[idx] = this.lastMethodUnobf[idx];
                continue;
            }
            if (ns == this.testNsId) {
                this.unobf[idx] = true;
                if (targetKind != MappedElementKind.METHOD) continue;
                this.lastMethodUnobf[idx] = true;
                continue;
            }
            if (this.unobf[idx]) continue;
            String name = ns == -1 ? this.srcName : this.dstNames[ns];
            String testName = this.dstNames[this.testNsId];
            if (testName == null || !testName.equals(name)) continue;
            this.unobf[idx] = true;
            if (targetKind != MappedElementKind.METHOD) continue;
            this.lastMethodUnobf[idx] = true;
        }
        block1: for (int i = 0; i < this.dstNames.length; ++i) {
            String name = this.dstNames[i];
            if (name == null) {
                int src = i;
                long visited = 1L << src;
                do {
                    int newSrc;
                    if ((newSrc = this.alternativesMapping[src]) < 0) {
                        if (!this.unobf[newSrc + 1]) continue block1;
                        name = this.srcName;
                        break;
                    }
                    if (newSrc == src || (visited & 1L << newSrc) != 0L || !this.unobf[newSrc + 1]) continue block1;
                    src = newSrc;
                    name = this.dstNames[src];
                    visited |= 1L << src;
                } while (name == null);
                assert (name != null);
            }
            this.next.visitDstName(targetKind, i, name);
        }
        Arrays.fill(this.dstNames, null);
        Arrays.fill(this.unobf, false);
        Arrays.fill(this.lastMethodUnobf, false);
        return this.next.visitElementContent(targetKind);
    }
}

