/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerEntry;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.jetbrains.annotations.Nullable;

public record LocalAccessWidenerEntry(Path path, String hash) implements AccessWidenerEntry
{
    public static LocalAccessWidenerEntry create(Path path) {
        return new LocalAccessWidenerEntry(path, Checksum.of(path).sha1().hex());
    }

    @Override
    public void read(ClassTweakerVisitor visitor, LazyCloseable<TinyRemapper> remapper) throws IOException {
        ClassTweakerReader reader = ClassTweakerReader.create((ClassTweakerVisitor)visitor);
        reader.read(Files.readAllBytes(this.path), null);
    }

    @Override
    public void readOfficial(ClassTweakerVisitor visitor) throws IOException {
        byte[] data = Files.readAllBytes(this.path);
        ClassTweakerReader.Header header = ClassTweakerReader.readHeader((byte[])data);
        if (!header.getNamespace().equals(MappingsNamespace.OFFICIAL.toString())) {
            throw new IOException("Expected official namespace for access widener entry, found: " + header.getNamespace());
        }
        ClassTweakerReader reader = ClassTweakerReader.create((ClassTweakerVisitor)visitor);
        reader.read(data, null);
    }

    @Override
    public ModEnvironment environment() {
        return ModEnvironment.UNIVERSAL;
    }

    @Override
    @Nullable
    public String mappingId() {
        return null;
    }

    @Override
    public String getSortKey() {
        return "local";
    }

    @Override
    public int hashCode() {
        return this.hash.hashCode();
    }
}

