/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import net.fabricmc.loom.configuration.mods.dependency.ModDependencyOptions;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.Nullable;

public final class SimpleModDependency
extends ModDependency {
    private final Configuration targetConfig;
    private final LocalMavenHelper maven;

    public SimpleModDependency(ArtifactRef artifact, ArtifactMetadata metadata, ModDependencyOptions options, Configuration targetConfig, Project project) {
        super(artifact, metadata, options);
        this.targetConfig = Objects.requireNonNull(targetConfig);
        this.maven = this.createMavenHelper(project, null);
    }

    @Override
    public boolean isCacheInvalid(Project project, @Nullable String variant) {
        return !this.maven.exists(variant);
    }

    @Override
    public void copyToCache(Project project, Path path, @Nullable String variant) throws IOException {
        this.maven.copyToMaven(path, variant);
    }

    @Override
    public void applyToProject(Project project) {
        project.getDependencies().add(this.targetConfig.getName(), (Object)this.maven.getNotation());
    }
}

