/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;

public class GradleTypeAdapter
implements TypeAdapterFactory {
    public static final Gson GSON = new Gson().newBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GradleTypeAdapter()).create();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawClass = type.getRawType();
        if (FileCollection.class.isAssignableFrom(rawClass)) {
            return new FileCollectionTypeAdapter();
        }
        if (RegularFileProperty.class.isAssignableFrom(rawClass)) {
            return new RegularFilePropertyTypeAdapter();
        }
        if (DirectoryProperty.class.isAssignableFrom(rawClass)) {
            return new DirectoryPropertyTypeAdapter();
        }
        if (ListProperty.class.isAssignableFrom(rawClass)) {
            return new ListPropertyTypeAdapter(gson);
        }
        if (MapProperty.class.isAssignableFrom(rawClass)) {
            return new MapPropertyTypeAdapter(gson);
        }
        if (Property.class.isAssignableFrom(rawClass)) {
            return new PropertyTypeAdapter(gson);
        }
        return null;
    }

    private static final class FileCollectionTypeAdapter<T extends FileCollection>
    extends WriteOnlyTypeAdapter<T> {
        private FileCollectionTypeAdapter() {
        }

        public void write(JsonWriter out, T fileCollection) throws IOException {
            out.beginArray();
            List<String> files = fileCollection.getFiles().stream().map(File::getAbsolutePath).sorted().toList();
            for (String file : files) {
                out.value(file);
            }
            out.endArray();
        }
    }

    private static final class RegularFilePropertyTypeAdapter<T extends RegularFileProperty>
    extends WriteOnlyTypeAdapter<T> {
        private RegularFilePropertyTypeAdapter() {
        }

        public void write(JsonWriter out, T property) throws IOException {
            if (!property.isPresent()) {
                out.nullValue();
                return;
            }
            File file = ((RegularFile)property.get()).getAsFile();
            out.value(file.getAbsolutePath());
        }
    }

    private static final class DirectoryPropertyTypeAdapter<T extends DirectoryProperty>
    extends WriteOnlyTypeAdapter<T> {
        private DirectoryPropertyTypeAdapter() {
        }

        public void write(JsonWriter out, T property) throws IOException {
            if (!property.isPresent()) {
                out.nullValue();
                return;
            }
            File file = ((Directory)property.get()).getAsFile();
            out.value(file.getAbsolutePath());
        }
    }

    private static final class ListPropertyTypeAdapter<T extends ListProperty<?>>
    extends WriteOnlyTypeAdapter<T> {
        private final Gson gson;

        private ListPropertyTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, T property) throws IOException {
            List objects = (List)property.get();
            out.beginArray();
            for (Object o : objects) {
                TypeAdapter adapter = this.gson.getAdapter(o.getClass());
                adapter.write(out, o);
            }
            out.endArray();
        }
    }

    private static final class MapPropertyTypeAdapter<T extends MapProperty<?, ?>>
    extends WriteOnlyTypeAdapter<T> {
        private final Gson gson;

        private MapPropertyTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, T property) throws IOException {
            out.beginObject();
            for (Map.Entry entry : ((Map)property.get()).entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String)) {
                    throw new UnsupportedOperationException("Map keys must be strings");
                }
                out.name(entry.getKey().toString());
                TypeAdapter adapter = this.gson.getAdapter(value.getClass());
                adapter.write(out, value);
            }
            out.endObject();
        }
    }

    private static final class PropertyTypeAdapter<T extends Property<?>>
    extends WriteOnlyTypeAdapter<T> {
        private final Gson gson;

        private PropertyTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, T property) throws IOException {
            if (!property.isPresent()) {
                out.nullValue();
                return;
            }
            Object o = property.get();
            TypeAdapter adapter = this.gson.getAdapter(o.getClass());
            adapter.write(out, o);
        }
    }

    private static abstract class WriteOnlyTypeAdapter<T>
    extends TypeAdapter<T> {
        private WriteOnlyTypeAdapter() {
        }

        public final T read(JsonReader in) {
            throw new UnsupportedOperationException("This type adapter is write-only");
        }
    }
}

