/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import net.fabricmc.classtweaker.api.visitor.AccessWidenerVisitor;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.processor.MappingProcessorContext;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerEntry;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerJarProcessor;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransitiveAccessWidenerMappingsProcessor
implements MinecraftJarProcessor.MappingsProcessor<AccessWidenerJarProcessor.Spec> {
    public static final TransitiveAccessWidenerMappingsProcessor INSTANCE = new TransitiveAccessWidenerMappingsProcessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(TransitiveAccessWidenerMappingsProcessor.class);

    private TransitiveAccessWidenerMappingsProcessor() {
    }

    @Override
    public boolean transform(MemoryMappingTree mappings, AccessWidenerJarProcessor.Spec spec, MappingProcessorContext context) {
        List<AccessWidenerEntry> accessWideners = spec.accessWideners().stream().filter(entry -> entry.mappingId() != null).toList();
        if (accessWideners.isEmpty()) {
            return false;
        }
        if (!context.getProductionNamespace().toString().equals(mappings.getSrcNamespace())) {
            throw new IllegalStateException("Mapping tree must have " + context.getProductionNamespace().toString() + " src mappings not " + mappings.getSrcNamespace());
        }
        try (LazyCloseable<TinyRemapper> remapper = context.createRemapper(context.getProductionNamespace(), MappingsNamespace.NAMED);){
            for (AccessWidenerEntry accessWidener : accessWideners) {
                MappingCommentClassTweakerVisitor visitor = new MappingCommentClassTweakerVisitor(accessWidener.mappingId(), mappings);
                accessWidener.read(visitor, remapper, context.getProductionNamespace());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to transform access widener mappings", e);
        }
        return true;
    }

    private record MappingCommentClassTweakerVisitor(String modId, MemoryMappingTree mappingTree) implements ClassTweakerVisitor
    {
        public AccessWidenerVisitor visitAccessWidener(String owner) {
            return new MappingCommentAccessWidenerVisitor(owner);
        }

        private class MappingCommentAccessWidenerVisitor
        implements AccessWidenerVisitor {
            private final String className;

            private MappingCommentAccessWidenerVisitor(String className) {
                this.className = className;
            }

            public void visitClass(AccessWidenerVisitor.AccessType access, boolean transitive) {
                MappingTree.ClassMapping classMapping = MappingCommentClassTweakerVisitor.this.mappingTree.getClass(this.className);
                if (classMapping == null) {
                    LOGGER.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)this.className, (Object)MappingCommentClassTweakerVisitor.this.modId());
                    return;
                }
                classMapping.setComment(this.appendComment(classMapping.getComment(), access));
            }

            public void visitMethod(String name, String descriptor, AccessWidenerVisitor.AccessType access, boolean transitive) {
                this.visitClass(access, transitive);
                MappingTree.ClassMapping classMapping = MappingCommentClassTweakerVisitor.this.mappingTree.getClass(this.className);
                if (classMapping == null) {
                    LOGGER.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)this.className, (Object)MappingCommentClassTweakerVisitor.this.modId());
                    return;
                }
                MappingTree.MethodMapping methodMapping = classMapping.getMethod(name, descriptor);
                if (methodMapping == null) {
                    LOGGER.info("Failed to find method ({}) in ({}) to mark access widened by mod ({})", new Object[]{name, this.className, MappingCommentClassTweakerVisitor.this.modId()});
                    return;
                }
                methodMapping.setComment(this.appendComment(methodMapping.getComment(), access));
            }

            public void visitField(String name, String descriptor, AccessWidenerVisitor.AccessType access, boolean transitive) {
                this.visitClass(access, transitive);
                MappingTree.ClassMapping classMapping = MappingCommentClassTweakerVisitor.this.mappingTree.getClass(this.className);
                if (classMapping == null) {
                    LOGGER.info("Failed to find class ({}) to mark access widened by mod ({})", (Object)name, (Object)MappingCommentClassTweakerVisitor.this.modId());
                    return;
                }
                MappingTree.FieldMapping fieldMapping = classMapping.getField(name, descriptor);
                if (fieldMapping == null) {
                    LOGGER.info("Failed to find field ({}) in ({}) to mark access widened by mod ({})", new Object[]{name, this.className, MappingCommentClassTweakerVisitor.this.modId()});
                    return;
                }
                fieldMapping.setComment(this.appendComment(fieldMapping.getComment(), access));
            }

            private String appendComment(String comment, AccessWidenerVisitor.AccessType access) {
                String awComment;
                if (!((String)(comment = comment == null ? "" : (String)comment + "\n")).contains(awComment = "Access widened by %s to %s".formatted(MappingCommentClassTweakerVisitor.this.modId(), access))) {
                    comment = (String)comment + awComment;
                }
                return comment;
            }
        }
    }
}

