/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;

public final class LegacyMergedMinecraftProvider
extends MinecraftProvider {
    private final SingleJarMinecraftProvider.Server serverMinecraftProvider;
    private final SingleJarMinecraftProvider.Client clientMinecraftProvider;

    public LegacyMergedMinecraftProvider(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        super(metadataProvider, configContext);
        this.serverMinecraftProvider = SingleJarMinecraftProvider.server(metadataProvider, configContext);
        this.clientMinecraftProvider = SingleJarMinecraftProvider.client(metadataProvider, configContext);
        if (!this.isLegacyVersion()) {
            throw new RuntimeException("something has gone wrong - legacy-merged jar configuration selected but Minecraft " + metadataProvider.getMinecraftVersion() + " allows merging the obfuscated jars - the merged jar configuration should have been selected!");
        }
    }

    public SingleJarMinecraftProvider.Server getServerMinecraftProvider() {
        return this.serverMinecraftProvider;
    }

    public SingleJarMinecraftProvider.Client getClientMinecraftProvider() {
        return this.clientMinecraftProvider;
    }

    @Override
    public void provide() throws Exception {
        if (!this.serverMinecraftProvider.provideServer() || !this.clientMinecraftProvider.provideClient()) {
            throw new UnsupportedOperationException("This version does not provide both the client and server jars - please select the client-only or server-only jar configuration!");
        }
        this.serverMinecraftProvider.provide();
        this.clientMinecraftProvider.provide();
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.serverMinecraftProvider.getMinecraftEnvOnlyJar(), this.clientMinecraftProvider.getMinecraftEnvOnlyJar());
    }

    @Override
    @Deprecated
    public MappingsNamespace getOfficialNamespace() {
        throw new UnsupportedOperationException("Cannot query the official namespace for legacy-merged minecraft providers");
    }
}

