/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Transformer;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.WorkerDaemonClientsManager;

public class WorkerDaemonClientsManagerHelper {
    public static final String MARKER_PROP = "fabric.loom.decompile.worker";

    public static boolean stopIdleJVM(WorkerDaemonClientsManager manager, String jvmMarkerValue) {
        AtomicBoolean stopped = new AtomicBoolean(false);
        Transformer transformer = workerDaemonClients -> {
            for (Object client : workerDaemonClients) {
                DaemonForkOptions forkOptions = WorkerDaemonClientsManagerHelper.getForkOptions(client);
                Map<String, Object> systemProperties = WorkerDaemonClientsManagerHelper.getSystemProperties(forkOptions);
                if (systemProperties == null || !jvmMarkerValue.equals(systemProperties.get(MARKER_PROP))) continue;
                stopped.set(true);
                return Collections.singletonList(client);
            }
            return Collections.emptyList();
        };
        try {
            Method selectIdleClientsToStop = manager.getClass().getDeclaredMethod("selectIdleClientsToStop", Transformer.class);
            selectIdleClientsToStop.setAccessible(true);
            selectIdleClientsToStop.invoke((Object)manager, transformer);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to selectIdleClientsToStop", e);
        }
        return stopped.get();
    }

    private static Map<String, Object> getSystemProperties(DaemonForkOptions forkOptions) {
        try {
            Method getJavaForkOptionsMethod = forkOptions.getClass().getDeclaredMethod("getJavaForkOptions", new Class[0]);
            getJavaForkOptionsMethod.setAccessible(true);
            Object javaForkOptions = getJavaForkOptionsMethod.invoke((Object)forkOptions, new Object[0]);
            Method getSystemPropertiesMethod = javaForkOptions.getClass().getDeclaredMethod("getSystemProperties", new Class[0]);
            getSystemPropertiesMethod.setAccessible(true);
            return (Map)getSystemPropertiesMethod.invoke(javaForkOptions, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException getJavaForkOptionsMethod) {
            try {
                Method getJvmOptions = forkOptions.getClass().getDeclaredMethod("getJvmOptions", new Class[0]);
                getJvmOptions.setAccessible(true);
                Object jvmOptions = getJvmOptions.invoke((Object)forkOptions, new Object[0]);
                Method getMutableSystemProperties = jvmOptions.getClass().getDeclaredMethod("getMutableSystemProperties", new Class[0]);
                getMutableSystemProperties.setAccessible(true);
                return (Map)getMutableSystemProperties.invoke(jvmOptions, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to daemon system properties", e);
            }
        }
    }

    private static DaemonForkOptions getForkOptions(Object client) {
        try {
            Method getForkOptionsMethod = client.getClass().getDeclaredMethod("getForkOptions", new Class[0]);
            getForkOptionsMethod.setAccessible(true);
            return (DaemonForkOptions)getForkOptionsMethod.invoke(client, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

