/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.imfwd;

import com.google.gson.stream.JsonReader;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("/net/fabricmc/intermediary/([^/]{1,50})/intermediary-\\1\\.([\\.\\w]{1,20})");
    private static final String RESPONSE = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n";
    private static final byte[] RESPONSE_302 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "302 Found").getBytes(StandardCharsets.UTF_8);
    private static final byte[] RESPONSE_404 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "404 Not Found").getBytes(StandardCharsets.UTF_8);
    private static final byte[] RESPONSE_405 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "405 Not Allowed").getBytes(StandardCharsets.UTF_8);
    private static final byte[] RESPONSE_500 = "<html><head><title>ERR</title></head><body><center><h1>ERR</h1></center></body></html>\n".replace("ERR", "500 Internal Server Error").getBytes(StandardCharsets.UTF_8);
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private static final Map<String, CacheEntry> CACHE = Collections.synchronizedMap(new LinkedHashMap<String, CacheEntry>(500){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
            return this.size() >= 500;
        }
    });
    private static final Map<String, Instant> RELEASE_TIMES = new HashMap<String, Instant>();
    private static long lastReleaseTimeUpdate;
    private static String metaScheme;
    private static String metaHost;
    private static int metaPort;
    private static String mavenScheme;
    private static String mavenHost;
    private static int mavenPort;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            throw new IllegalArgumentException("usage: <metaUrl> <mavenUrl>");
        }
        URI metaUrl = URI.create(args[0]);
        metaScheme = metaUrl.getScheme();
        metaHost = metaUrl.getHost();
        metaPort = metaUrl.getPort();
        URI mavenUrl = URI.create(args[1]);
        mavenScheme = mavenUrl.getScheme();
        mavenHost = mavenUrl.getHost();
        mavenPort = mavenUrl.getPort();
        HttpServer server = HttpServer.create(new InetSocketAddress(InetAddress.getLoopbackAddress(), 13694), 0);
        server.createContext("/net/fabricmc/intermediary/", Main::handleIntermediary);
        server.start();
        System.out.println("intermediary forwarder running");
    }

    private static void handleIntermediary(HttpExchange exchange) throws IOException {
        try (HttpExchange httpExchange = exchange;){
            int result;
            exchange.getRequestBody().transferTo(OutputStream.nullOutputStream());
            String method = exchange.getRequestMethod();
            if (!method.equals("GET") && !method.equals("HEAD")) {
                exchange.getResponseHeaders().add("Allow", "HEAD, GET");
                result = 405;
            } else {
                CacheEntry entry;
                Matcher matcher = REQUEST_PATTERN.matcher(exchange.getRequestURI().getRawPath());
                if (!matcher.matches() || (entry = Main.getNewIntermediary(matcher.group(1))) != null && entry.isAbsent()) {
                    result = 404;
                } else if (entry == null) {
                    result = 500;
                } else {
                    String newLocation = String.format("/net/fabricmc/intermediary/%s/intermediary-%<s.%s", entry.newVersion(), matcher.group(2));
                    exchange.getResponseHeaders().add("Location", newLocation);
                    exchange.getResponseHeaders().add("Last-Modified", entry.lastModified());
                    result = 302;
                }
            }
            byte[] response = switch (result) {
                case 302 -> RESPONSE_302;
                case 404 -> RESPONSE_404;
                case 405 -> RESPONSE_405;
                case 500 -> RESPONSE_500;
                default -> throw new IllegalStateException();
            };
            if (method.equals("HEAD")) {
                exchange.getResponseHeaders().set("Content-Length", Integer.toString(response.length));
                exchange.sendResponseHeaders(result, -1L);
            } else {
                exchange.sendResponseHeaders(result, response.length);
                exchange.getResponseBody().write(response);
            }
        }
    }

    private static CacheEntry getNewIntermediary(String version) {
        CacheEntry ret = CACHE.get(version);
        if (ret != null && !ret.isExpired()) {
            return ret;
        }
        return Main.computeNewIntermediary(version);
    }

    private static synchronized CacheEntry computeNewIntermediary(String version) {
        CacheEntry ret = CACHE.get(version);
        if (ret != null && !ret.isExpired()) {
            return ret;
        }
        try {
            URI uri = new URI(metaScheme, null, metaHost, metaPort, "/v2/versions/intermediary/" + version, null, null);
            HttpRequest request = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(5L)).build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return null;
            }
            if (response.body().startsWith("[]")) {
                ret = CacheEntry.ofAbsent();
            } else {
                String newVersion = Main.parseVersion(response.body());
                if (newVersion == null) {
                    return null;
                }
                if (newVersion.equals(version)) {
                    ret = CacheEntry.ofAbsent();
                } else {
                    Instant releaseTime = Main.getReleaseTime(version);
                    if (releaseTime == null) {
                        return null;
                    }
                    ret = CacheEntry.of(newVersion, releaseTime);
                }
            }
            CACHE.put(version, ret);
            return ret;
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            System.out.println("meta request failed: " + String.valueOf(e));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String parseVersion(String metaVersionJson) {
        try (JsonReader reader = new JsonReader(new StringReader(metaVersionJson));){
            reader.beginArray();
            if (!reader.hasNext()) {
                String string = null;
                return string;
            }
            reader.beginObject();
            while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "version": {
                        String string = reader.nextString();
                        return string;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            reader.endArray();
            return null;
        }
        catch (Exception e) {
            System.out.println("meta response parsing failed: " + String.valueOf(e));
        }
        return null;
    }

    private static synchronized Instant getReleaseTime(String version) {
        Map<String, Instant> fabricExpResult;
        Instant ret = RELEASE_TIMES.get(version);
        if (ret != null) {
            return ret;
        }
        long time = System.nanoTime();
        if (lastReleaseTimeUpdate != 0L && time - lastReleaseTimeUpdate < 30000000000L) {
            return null;
        }
        lastReleaseTimeUpdate = time;
        Map<String, Instant> mcMetaResult = Main.fetchReleaseTimes(URI.create("https://piston-meta.mojang.com/mc/game/version_manifest.json"));
        try {
            fabricExpResult = Main.fetchReleaseTimes(new URI(mavenScheme, null, mavenHost, mavenPort, "/net/minecraft/experimental_versions.json", null, null));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (mcMetaResult == null || fabricExpResult == null) {
            return null;
        }
        RELEASE_TIMES.clear();
        RELEASE_TIMES.putAll(fabricExpResult);
        RELEASE_TIMES.putAll(mcMetaResult);
        return RELEASE_TIMES.get(version);
    }

    private static Map<String, Instant> fetchReleaseTimes(URI url) {
        try {
            HttpRequest request = HttpRequest.newBuilder(url).timeout(Duration.ofSeconds(5L)).build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("http request failed: " + response.statusCode());
            }
            HashMap<String, Instant> ret = new HashMap<String, Instant>();
            try (JsonReader reader = new JsonReader(new StringReader(response.body()));){
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if (!key.equals("versions")) {
                        reader.skipValue();
                        continue;
                    }
                    reader.beginArray();
                    while (reader.hasNext()) {
                        String id = null;
                        String releaseTime = null;
                        reader.beginObject();
                        block17: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "id": {
                                    id = reader.nextString();
                                    continue block17;
                                }
                                case "releaseTime": {
                                    releaseTime = reader.nextString();
                                    continue block17;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        if (id == null || releaseTime == null) {
                            throw new IOException("missing id or releaseTime in version entry");
                        }
                        ret.put(id, Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(releaseTime)));
                    }
                    reader.endArray();
                }
                reader.endObject();
            }
            return ret;
        }
        catch (Exception e) {
            System.out.println("maven manifest request failed: " + String.valueOf(e));
            return null;
        }
    }

    private record CacheEntry(String newVersion, String lastModified, long time) {
        static CacheEntry of(String newVersion, Instant releaseTime) {
            return new CacheEntry(newVersion, DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT")).format(releaseTime), System.nanoTime());
        }

        static CacheEntry ofAbsent() {
            return new CacheEntry(null, null, System.nanoTime());
        }

        boolean isAbsent() {
            return this.newVersion == null;
        }

        boolean isExpired() {
            return this.isAbsent() && System.nanoTime() - this.time > 60000000000L;
        }
    }
}

