/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin.annotation;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cadixdev.mercury.mixin.annotation.DescData;
import org.cadixdev.mercury.mixin.annotation.InjectTarget;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;

public class AtData {
    private static final Pattern DOT_REF_PATTERN = Pattern.compile("([\\w_$/]+)\\.(.*\\(.*?\\).+)");
    private static final Pattern METHOD_REF_PATTERN = Pattern.compile("^(\\(.*?\\).+)$");
    private final String injectionPoint;
    private final String className;
    private final InjectTarget target;
    private final DescData desc;

    public static AtData from(IAnnotationBinding binding) {
        String injectionPoint = null;
        String className = null;
        InjectTarget target = null;
        DescData desc = null;
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            if (Objects.equals("value", pair.getName())) {
                injectionPoint = (String)pair.getValue();
                continue;
            }
            if (Objects.equals("target", pair.getName())) {
                String combined = (String)pair.getValue();
                Matcher methodDescMatcher = METHOD_REF_PATTERN.matcher(combined);
                if (methodDescMatcher.matches()) {
                    className = null;
                    target = InjectTarget.of(combined);
                    break;
                }
                int semiIndex = combined.indexOf(59);
                if (semiIndex >= 0) {
                    className = combined.substring(1, semiIndex);
                    target = InjectTarget.of(combined.substring(semiIndex + 1));
                    continue;
                }
                Matcher matcher = DOT_REF_PATTERN.matcher(combined);
                if (matcher.matches()) {
                    className = matcher.group(1);
                    target = InjectTarget.of(matcher.group(2));
                    continue;
                }
                className = combined;
                continue;
            }
            if (!"desc".equals(pair.getName())) continue;
            desc = DescData.from((IAnnotationBinding)pair.getValue());
        }
        return new AtData(injectionPoint, className, target, desc);
    }

    public AtData(String injectionPoint, String className, InjectTarget target, DescData desc) {
        this.injectionPoint = injectionPoint;
        this.className = className;
        this.target = target;
        this.desc = desc;
    }

    public String getInjectionPoint() {
        return this.injectionPoint;
    }

    public Optional<String> getClassName() {
        return Optional.ofNullable(this.className);
    }

    public Optional<InjectTarget> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<DescData> getDesc() {
        return Optional.ofNullable(this.desc);
    }

    public String toString() {
        return "AtData{injectionPoint='" + this.injectionPoint + '\'' + ", className='" + this.className + '\'' + ", target=" + this.target + '}';
    }
}

